/*
 * Decompiled with CFR 0.152.
 */
package unearthables;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;

public class TopazHUD
extends Sprite {
    public State currentState;
    public State previousState;
    private Animation<TextureRegion> on;
    private float _stateTimer;
    private boolean isAnimationOver;
    private TextureRegion main;
    private Texture t1;
    public Color color;
    public Rectangle rect = new Rectangle();
    private int _sw;
    private int _sh;
    public boolean isDead;

    public TopazHUD(float _x, float _y) {
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 15.0f;
        this.rect.height = 15.0f;
        this._sw = 15;
        this._sh = 15;
        this.t1 = new Texture(Gdx.files.internal("topaz.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        this.on = new Animation(MathUtils.random(0.1f, 0.2f), frames, Animation.PlayMode.LOOP);
        frames.clear();
        this.color = Color.WHITE;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    private void Update(float __x, float __y) {
        this.rect.x = __x;
        this.rect.y = __y;
    }

    public TextureRegion getFrame(OrthographicCamera camera, float dt, float __x, float __y) {
        TextureRegion region;
        this.Update(__x, __y);
        this.currentState = this.getState();
        switch (this.currentState) {
            case ON: {
                region = this.on.getKeyFrame(this._stateTimer, true);
                break;
            }
            case MAIN: {
                region = this.main;
                break;
            }
            default: {
                region = this.on.getKeyFrame(this._stateTimer, true);
            }
        }
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return region;
    }

    public State getState() {
        return State.ON;
    }

    public void render(rcr game, OrthographicCamera camera, float dt, float followX, float followY) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(camera, dt, followX, followY), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN,
        ON;

    }
}

