/*
 * Decompiled with CFR 0.152.
 */
package levelElements;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;
import java.util.UUID;

public class Portal
extends Sprite {
    public State currentState;
    public State previousState;
    private TextureRegion main;
    private Texture t1;
    private Animation<TextureRegion> on;
    private float _stateTimer;
    private boolean isAnimationOver;
    public Color color;
    public Rectangle rect;
    private int _sw;
    private int _sh;
    public UUID uuid = UUID.randomUUID();
    public boolean isDead;
    public boolean canHit;

    public Portal(float _x, float _y) {
        this.rect = new Rectangle();
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 100.0f;
        this.rect.height = 100.0f;
        this._sw = 100;
        this._sh = 100;
        System.out.println("The portal is open! x: " + _x + "y: " + _y);
        this.currentState = State.MAIN;
        this.previousState = State.ON;
        this._stateTimer = 0.0f;
        this.t1 = new Texture(Gdx.files.internal("portal.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 3 * this._sw, 0 * this._sh, this._sw, this._sh));
        this.on = new Animation(MathUtils.random(0.2f, 0.4f), frames, Animation.PlayMode.LOOP);
        frames.clear();
        this.color = Color.WHITE;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    public TextureRegion getFrame(float dt, OrthographicCamera camera) {
        TextureRegion region;
        this.currentState = this.getState();
        this.update();
        switch (this.currentState) {
            case ON: {
                region = this.on.getKeyFrame(this._stateTimer, true);
                break;
            }
            case MAIN: {
                region = this.main;
                break;
            }
            default: {
                region = this.on.getKeyFrame(this._stateTimer, true);
            }
        }
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return region;
    }

    private void update() {
    }

    public State getState() {
        if (this.isDead) {
            return State.MAIN;
        }
        return State.ON;
    }

    public void render(rcr game, OrthographicCamera camera, float dt) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(dt, camera), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN,
        ON;

    }
}

