/*
 * Decompiled with CFR 0.152.
 */
package effects;

import Global.Global;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;

public class Explosion
extends Sprite {
    public State currentState;
    public State previousState;
    private Animation<TextureRegion> main;
    private Texture t1;
    public Color color;
    public Rectangle rect = new Rectangle();
    private int _sw;
    private int _sh;
    private boolean isAnimationOver;
    private float _stateTimer;
    public float speed = 200.0f;
    public boolean isDead;
    public boolean isResetAnimation;
    public boolean canHit;
    private Sound boom;

    public Explosion(float _x, float _y) {
        this.rect.x = (int)_x + 50;
        this.rect.y = (int)_y + 50;
        this.rect.width = 50.0f;
        this.rect.height = 50.0f;
        this._sw = 50;
        this._sh = 50;
        this.boom = Gdx.audio.newSound(Gdx.files.internal("sfx/boom.ogg"));
        this.t1 = new Texture(Gdx.files.internal("explosion.png"));
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 3 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 1 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 1 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 1 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 3 * this._sw, 1 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 2 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 2 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 2 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 3 * this._sw, 2 * this._sh, this._sw, this._sh));
        this.main = new Animation(0.06f, frames, Animation.PlayMode.NORMAL);
        frames.clear();
        this.color = Color.WHITE;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main.getKeyFrame(this._stateTimer, true));
    }

    public void update(State cs, float dt) {
        if (!this.isDead && !this.isResetAnimation) {
            this.isResetAnimation = true;
            this._stateTimer = 0.0f;
            this.setRegion(this.main.getKeyFrame(this._stateTimer));
            if (!Global.SetVolumeToZero.booleanValue()) {
                this.boom.play(0.1f);
            }
        }
        if (this.main.isAnimationFinished(this._stateTimer)) {
            this.isDead = true;
        }
    }

    public TextureRegion getFrame(OrthographicCamera camera, float dt) {
        TextureRegion region;
        this.currentState = this.getState();
        this.update(this.currentState, dt);
        switch (this.currentState) {
            case MAIN: {
                region = this.main.getKeyFrame(this._stateTimer, false);
                break;
            }
            default: {
                region = this.main.getKeyFrame(this._stateTimer, false);
            }
        }
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return region;
    }

    public State getState() {
        return State.MAIN;
    }

    public void render(rcr game, OrthographicCamera camera, float dt) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(camera, dt), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN;

    }
}

