/*
 * Decompiled with CFR 0.152.
 */
package de.golfgl.gdx.controllers.mapping;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.utils.Array;
import de.golfgl.gdx.controllers.mapping.ControllerMappings;
import de.golfgl.gdx.controllers.mapping.MappedControllerAdapter;
import java.util.HashMap;

public class ControllerToInputAdapter
extends MappedControllerAdapter {
    public float analogToDigitalTreshold;
    private InputProcessor targetInput;
    private HashMap<Integer, Integer> buttonMappings;
    private HashMap<Integer, AxisMapping> axisMappings;

    public ControllerToInputAdapter(ControllerMappings mappings) {
        super(mappings);
        this.analogToDigitalTreshold = mappings.analogToDigitalTreshold;
        this.buttonMappings = new HashMap();
        this.axisMappings = new HashMap();
    }

    public InputProcessor getInputProcessor() {
        return this.targetInput;
    }

    public void setInputProcessor(InputProcessor targetInput) {
        this.targetInput = targetInput;
    }

    @Override
    public boolean configuredAxisMoved(Controller controller, int axisId, float value) {
        boolean positivePressed;
        boolean negativePressed;
        if (this.targetInput == null || !this.axisMappings.containsKey(axisId)) {
            return false;
        }
        AxisMapping thisMapping = this.axisMappings.get(axisId);
        if (value >= this.analogToDigitalTreshold) {
            negativePressed = false;
            positivePressed = true;
        } else if (value <= -this.analogToDigitalTreshold) {
            negativePressed = true;
            positivePressed = false;
        } else {
            negativePressed = false;
            positivePressed = false;
        }
        boolean negativeChanged = thisMapping.setNegativeKeyPressed(controller, negativePressed);
        boolean positiveChanged = thisMapping.setPositiveKeyPressed(controller, positivePressed);
        if (negativeChanged) {
            if (negativePressed) {
                this.sendKeyDownToTarget(thisMapping.keyCodeNegative, controller);
            } else {
                this.sendKeyUpToTarget(thisMapping.keyCodeNegative, controller);
            }
        }
        if (positiveChanged) {
            if (positivePressed) {
                this.sendKeyDownToTarget(thisMapping.keyCodePositive, controller);
            } else {
                this.sendKeyUpToTarget(thisMapping.keyCodePositive, controller);
            }
        }
        return true;
    }

    @Override
    public boolean configuredButtonDown(Controller controller, int buttonId) {
        if (this.targetInput == null || !this.buttonMappings.containsKey(buttonId)) {
            return false;
        }
        return this.sendKeyDownToTarget(this.buttonMappings.get(buttonId), controller);
    }

    @Override
    public boolean configuredButtonUp(Controller controller, int buttonId) {
        if (this.targetInput == null || !this.buttonMappings.containsKey(buttonId)) {
            return false;
        }
        return this.sendKeyUpToTarget(this.buttonMappings.get(buttonId), controller);
    }

    protected boolean sendKeyDownToTarget(int keycode, Controller inputSourceController) {
        return this.targetInput.keyDown(keycode);
    }

    protected boolean sendKeyUpToTarget(int keycode, Controller inputSourceController) {
        return this.targetInput.keyUp(keycode);
    }

    public ControllerToInputAdapter addButtonMapping(int configuredButtonId, int targetKeyCode) {
        this.buttonMappings.put(configuredButtonId, targetKeyCode);
        return this;
    }

    public ControllerToInputAdapter addAxisMapping(int configuredAxisId, int targetKeyCodeNegative, int targetKeyCodePositive) {
        AxisMapping axisMapping = new AxisMapping();
        axisMapping.keyCodeNegative = targetKeyCodeNegative;
        axisMapping.keyCodePositive = targetKeyCodePositive;
        this.axisMappings.put(configuredAxisId, axisMapping);
        return this;
    }

    private static class AxisMapping {
        public int keyCodeNegative;
        public int keyCodePositive;
        private Array<Controller> positivePressed = new Array(false, 2);
        private Array<Controller> negativePressed = new Array(false, 2);

        private AxisMapping() {
        }

        public boolean setNegativeKeyPressed(Controller controller, boolean negativePressed) {
            if (negativePressed && !this.negativePressed.contains(controller, true)) {
                this.negativePressed.add(controller);
                return true;
            }
            if (!negativePressed && this.negativePressed.contains(controller, true)) {
                this.negativePressed.removeValue(controller, true);
                return true;
            }
            return false;
        }

        public boolean setPositiveKeyPressed(Controller controller, boolean positivePressed) {
            if (positivePressed && !this.positivePressed.contains(controller, true)) {
                this.positivePressed.add(controller);
                return true;
            }
            if (!positivePressed && this.positivePressed.contains(controller, true)) {
                this.positivePressed.removeValue(controller, true);
                return true;
            }
            return false;
        }
    }
}

