/*
 * Decompiled with CFR 0.152.
 */
package u;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.collision.BoundingBox;

public class DebugRenderer {
    private static ShapeRenderer debugRenderer = new ShapeRenderer();

    public static void DrawDebugLine(Vector2 start, Vector2 end, int lineWidth, Color color, Matrix4 projectionMatrix) {
        Gdx.gl.glLineWidth(lineWidth);
        debugRenderer.setProjectionMatrix(projectionMatrix);
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.line(start, end);
        debugRenderer.end();
        Gdx.gl.glLineWidth(1.0f);
    }

    public static void DrawDebugLine(Vector2 start, Vector2 end, Color color, Matrix4 projectionMatrix) {
        Gdx.gl.glLineWidth(2.0f);
        debugRenderer.setProjectionMatrix(projectionMatrix);
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.line(start, end);
        debugRenderer.end();
        Gdx.gl.glLineWidth(1.0f);
    }

    public static void DrawDebugRectangle(Rectangle rect, Color color, Matrix4 projectionMatrix) {
        Gdx.gl.glLineWidth(2.0f);
        debugRenderer.setProjectionMatrix(projectionMatrix);
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.rect(rect.x, rect.y, rect.getWidth(), rect.getHeight());
        debugRenderer.end();
        Gdx.gl.glLineWidth(1.0f);
    }

    public static void DrawDebugRectangleFilled(Rectangle rect, Color color, Matrix4 projectionMatrix) {
        Gdx.gl.glLineWidth(1.0f);
        debugRenderer.setProjectionMatrix(projectionMatrix);
        debugRenderer.begin(ShapeRenderer.ShapeType.Filled);
        debugRenderer.setColor(color);
        debugRenderer.rect(rect.x, rect.y, rect.getWidth(), rect.getHeight());
        debugRenderer.end();
        Gdx.gl.glLineWidth(1.0f);
    }

    public static void DrawDebugBoundingBox(BoundingBox box, Color color, Matrix4 projectionMatrix) {
        Gdx.gl.glLineWidth(2.0f);
        debugRenderer.setProjectionMatrix(projectionMatrix);
        debugRenderer.begin(ShapeRenderer.ShapeType.Line);
        debugRenderer.setColor(color);
        debugRenderer.rect(box.min.x, box.min.y, box.getWidth(), box.getHeight());
        debugRenderer.end();
        Gdx.gl.glLineWidth(1.0f);
    }
}

