/*
 * Decompiled with CFR 0.152.
 */
package levelElements;

import Global.Global;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;
import entities.Student;
import java.util.UUID;

public class Bread
extends Sprite {
    public State currentState;
    public State previousState;
    private TextureRegion main;
    private Texture t1;
    private Animation<TextureRegion> on;
    private float _stateTimer;
    private boolean isAnimationOver;
    public Color color;
    public Rectangle rect;
    private int _sw;
    private int _sh;
    public UUID uuid = UUID.randomUUID();
    private Student st = new Student(0, 0);
    public boolean isCarried;
    public boolean isCarriedByPlayer;
    public boolean isDead;

    public Bread(float _x, float _y) {
        this.rect = new Rectangle();
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 50.0f;
        this.rect.height = 50.0f;
        this._sw = 50;
        this._sh = 50;
        System.out.println("The bread still lives--> x: " + _x + "y: " + _y);
        this.currentState = State.MAIN;
        this.previousState = State.ON;
        this._stateTimer = 0.0f;
        this.t1 = new Texture(Gdx.files.internal("bread.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 3 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 4 * this._sw, 0 * this._sh, this._sw, this._sh));
        this.on = new Animation(MathUtils.random(0.3f, 0.4f), frames, Animation.PlayMode.LOOP);
        frames.clear();
        this.color = new Color(MathUtils.random(0.8f, 0.9f), MathUtils.random(0.7f, 0.8f), MathUtils.random(0.5f, 0.6f), 1.0f);
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    public TextureRegion getFrame(float dt, OrthographicCamera camera, Array<Student> students) {
        TextureRegion region;
        this.currentState = this.getState();
        this.update(students, dt);
        switch (this.currentState) {
            case ON: {
                region = this.on.getKeyFrame(this._stateTimer, true);
                break;
            }
            case MAIN: {
                region = this.main;
                break;
            }
            default: {
                region = this.on.getKeyFrame(this._stateTimer, true);
            }
        }
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return region;
    }

    private void update(Array<Student> students, float dt) {
        if (!this.isDead) {
            for (int i = 0; i < students.size; ++i) {
                if (students.get((int)i).uuid != this.uuid) continue;
                this.st = students.get(i);
            }
            if (this.isCarried) {
                if (this.st.isDead) {
                    this.isCarried = false;
                }
                this.rect.x = this.st.rect.x + 10.0f;
                this.rect.y = this.st.rect.y + 50.0f;
            }
            if (this.isCarriedByPlayer) {
                this.rect.x = Global.P.x;
                this.rect.y = Global.P.y - 20.0f;
            }
        }
    }

    public State getState() {
        if (this.isDead) {
            return State.MAIN;
        }
        return State.ON;
    }

    public void render(rcr game, OrthographicCamera camera, float dt, Array<Student> students) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(dt, camera, students), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN,
        ON;

    }
}

