/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;
import effects.Explosion;
import u.UsefulMethods;

public class Ball
extends Sprite {
    public State currentState;
    public State previousState;
    protected Animation<TextureRegion> main;
    private Texture t1;
    private TextureRegion main2;
    private TextureRegion main3;
    private TextureRegion main4;
    private TextureRegion main5;
    private TextureRegion main6;
    private TextureRegion main7;
    private TextureRegion main8;
    private TextureRegion main9;
    private TextureRegion main10;
    private TextureRegion texture;
    public Color color;
    public Color _color;
    public Rectangle rect = new Rectangle();
    private int _sw;
    private int _sh;
    protected boolean isAnimationOver;
    protected float _stateTimer;
    public Vector2 sp;
    public Vector2 ep;
    public Vector2 dir;
    public Vector2 initDir;
    public float dist;
    public float newDist;
    public float speed = 400.0f;
    public float height = 100.0f;
    public boolean isDead = true;
    public boolean fired;
    public int ballLife = 0;
    public boolean firedOne;
    public Explosion explosion;
    public boolean canHit;

    public Ball(float _x, float _y, float endingPointX, float endingPointY) {
        this.rect.x = (int)_x + 30;
        this.rect.y = (int)_y + 50;
        this.rect.width = 10.0f;
        this.rect.height = 10.0f;
        this._sw = 10;
        this._sh = 10;
        this.sp = new Vector2(_x, _y);
        this.ep = new Vector2(endingPointX, endingPointY);
        this.dir = this.GetDirection(this.sp, this.ep);
        this.initDir = this.GetDirection(this.sp, this.ep);
        this.dist = UsefulMethods.GetDistance(this.sp, this.ep);
        this.canHit = true;
        this.explosion = new Explosion(_x, _y);
        this.t1 = new Texture(Gdx.files.internal("bomb.png"));
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        this.main = new Animation(0.1f, frames, Animation.PlayMode.LOOP);
        this.main2 = new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.main3 = new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.main4 = new TextureRegion(this.t1, 3 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.main5 = new TextureRegion(this.t1, 0 * this._sw, 1 * this._sh, this._sw, this._sh);
        this.main6 = new TextureRegion(this.t1, 1 * this._sw, 1 * this._sh, this._sw, this._sh);
        this.main7 = new TextureRegion(this.t1, 2 * this._sw, 1 * this._sh, this._sw, this._sh);
        this.main8 = new TextureRegion(this.t1, 3 * this._sw, 1 * this._sh, this._sw, this._sh);
        this.main9 = new TextureRegion(this.t1, 0 * this._sw, 2 * this._sh, this._sw, this._sh);
        this.main10 = new TextureRegion(this.t1, 1 * this._sw, 2 * this._sh, this._sw, this._sh);
        frames.clear();
        this.color = new Color(MathUtils.random(0.01f, 1.0f), MathUtils.random(0.01f, 1.0f), MathUtils.random(0.01f, 1.0f), 1.0f);
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setTheRegion();
        this.setRegion(this.main.getKeyFrame(this._stateTimer, true));
    }

    private void setTheRegion() {
        int randomTexture = MathUtils.random(1, 10);
        this.texture = randomTexture == 1 ? this.main.getKeyFrame(this._stateTimer, true) : (randomTexture == 2 ? this.main2 : (randomTexture == 3 ? this.main3 : (randomTexture == 4 ? this.main4 : (randomTexture == 5 ? this.main5 : (randomTexture == 6 ? this.main6 : (randomTexture == 7 ? this.main7 : (randomTexture == 8 ? this.main8 : (randomTexture == 9 ? this.main9 : (randomTexture == 10 ? this.main10 : this.main.getKeyFrame(this._stateTimer, true))))))))));
    }

    public TextureRegion getTextureRegion() {
        return this.texture;
    }

    public Vector2 GetDirection(Vector2 sp, Vector2 ep) {
        return ep.sub(sp).nor();
    }

    public void update(State cs, float dt) {
        if (this.isDead) {
            System.out.println("ball isdead: " + this.isDead);
        } else {
            if (this.fired) {
                this.rect.x += this.dir.x * this.speed * dt;
                this.rect.y += this.dir.y * this.speed * dt;
            }
            if (this.ballLife > 0) {
                --this.ballLife;
            }
            if (this.ballLife <= 0) {
                this.isDead = true;
                this.fired = false;
                this.explosion.rect.x = this.rect.x;
                this.explosion.rect.y = this.rect.y;
                this.explosion.isDead = false;
                this.explosion.isResetAnimation = false;
            }
        }
    }

    public TextureRegion getFrame(OrthographicCamera camera, float dt) {
        this.currentState = this.getState();
        this.update(this.currentState, dt);
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return this.texture;
    }

    public State getState() {
        return State.MAIN;
    }

    public void render(rcr game, OrthographicCamera camera, float dt) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(camera, dt), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN;

    }
}

