/*
 * Decompiled with CFR 0.152.
 */
package effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.ld58.game.rcr;

public class FireParticle
extends Sprite {
    private TextureRegion main;
    private Texture t1;
    public Color color;
    public Rectangle rect;
    private int _sw;
    private int _sh;
    private int MAXLIFE;
    private int life;
    private float speed;
    private float originSpeed;
    public boolean isDead;
    private float Xspeed;

    public FireParticle(float _x, float _y) {
        this.life = this.MAXLIFE = MathUtils.random(50, 100);
        this.speed = 0.1f;
        this.originSpeed = 0.1f;
        this.Xspeed = MathUtils.random(-1.0f, 1.0f);
        this.rect = new Rectangle();
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 1.0f;
        this.rect.height = 1.0f;
        this._sw = 1;
        this._sh = 1;
        this.t1 = new Texture(Gdx.files.internal("onePixel.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.color = new Color(MathUtils.random(0.1f, 1.0f), MathUtils.random(0.1f, 0.3f), MathUtils.random(0.1f, 0.3f), 1.0f);
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    private void update() {
        this.rect.y += this.speed * MathUtils.random(0.5f, 10.0f);
        this.speed -= MathUtils.random(0.01f, 0.04f);
        this.rect.x += this.Xspeed * MathUtils.random(0.01f, 0.5f);
        if (this.isDead) {
            this.rect.x += 0.0f;
            this.rect.y += 0.0f;
        }
        if (this.life > 0) {
            this.life -= 2;
        }
        if ((double)this.life >= (double)this.MAXLIFE * 0.8) {
            this.color = Color.YELLOW;
        }
        if ((double)this.life < (double)this.MAXLIFE * 0.8) {
            this.color = Color.GOLD;
        }
        if ((double)this.life <= (double)this.MAXLIFE * 0.6) {
            this.color = Color.ORANGE;
        }
        if ((double)this.life <= (double)this.MAXLIFE * 0.4) {
            this.color = Color.RED;
        }
        if ((double)this.life <= (double)this.MAXLIFE * 0.2) {
            this.color = Color.GRAY;
        }
        if (this.life <= 0) {
            this.life = this.MAXLIFE;
            this.speed = this.originSpeed;
            this.rect.x = 22.0f;
            this.rect.y = 10.0f;
        }
    }

    public TextureRegion getTextureRegion() {
        return this.main;
    }

    public void render(rcr game, OrthographicCamera camera, float dt) {
        this.update();
        game.batch.setColor(this.color);
        game.batch.draw(this.getTextureRegion(), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }
}

