/*
 * Decompiled with CFR 0.152.
 */
package de.golfgl.gdx.controllers.mapping;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerAdapter;
import de.golfgl.gdx.controllers.mapping.ConfiguredInput;
import de.golfgl.gdx.controllers.mapping.ControllerMappings;

public class MappedControllerAdapter
extends ControllerAdapter {
    ControllerMappings mappings;
    private float analogToDigitalTreshold;

    public MappedControllerAdapter(ControllerMappings mappings) {
        this.mappings = mappings;
        this.analogToDigitalTreshold = mappings.analogToDigitalTreshold;
    }

    public boolean configuredButtonDown(Controller controller, int buttonId) {
        return false;
    }

    public boolean configuredButtonUp(Controller controller, int buttonId) {
        return false;
    }

    public boolean configuredAxisMoved(Controller controller, int axisId, float value) {
        return false;
    }

    protected boolean buttonChange(Controller controller, int buttonIndex, boolean isDown) {
        boolean isReverse = false;
        ControllerMappings.MappedInputs mapping = this.mappings.getControllerMapping(controller);
        if (mapping == null) {
            return false;
        }
        ConfiguredInput configuredInput = mapping.getConfiguredFromButton(buttonIndex);
        if (configuredInput == null) {
            configuredInput = mapping.getConfiguredFromReverseButton(buttonIndex);
            isReverse = true;
        }
        if (configuredInput == null) {
            return false;
        }
        switch (configuredInput.inputType) {
            case button: {
                if (isDown) {
                    return this.configuredButtonDown(controller, configuredInput.inputId);
                }
                return this.configuredButtonUp(controller, configuredInput.inputId);
            }
            case axis: 
            case axisDigital: {
                return this.configuredAxisMoved(controller, configuredInput.inputId, !isDown ? 0.0f : (isReverse ? -1.0f : 1.0f));
            }
        }
        Gdx.app.log("CONTROLLERMAPPING", "Button mapped to analog axis not allowed!");
        return false;
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonIndex) {
        return this.buttonChange(controller, buttonIndex, true);
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonIndex) {
        return this.buttonChange(controller, buttonIndex, false);
    }

    @Override
    public boolean axisMoved(Controller controller, int axisIndex, float value) {
        ControllerMappings.MappedInputs mapping = this.mappings.getControllerMapping(controller);
        if (mapping == null) {
            return false;
        }
        ConfiguredInput configuredInput = mapping.getConfiguredFromAxis(axisIndex);
        if (configuredInput == null) {
            return false;
        }
        switch (configuredInput.inputType) {
            case axis: 
            case axisAnalog: {
                return this.configuredAxisMoved(controller, configuredInput.inputId, value);
            }
            case axisDigital: {
                return this.configuredAxisMoved(controller, configuredInput.inputId, Math.abs(value) < this.analogToDigitalTreshold ? 0.0f : 1.0f * Math.signum(value));
            }
        }
        Gdx.app.log("CONTROLLERMAPPING", "Axis mapped to button not allowed!");
        return false;
    }
}

