/*
 * Decompiled with CFR 0.152.
 */
package unearthables;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;
import entities.Student;
import java.util.UUID;

public class Platinum
extends Sprite {
    public State currentState;
    public State previousState;
    private Animation<TextureRegion> on;
    private float _stateTimer;
    private boolean isAnimationOver;
    private TextureRegion main;
    private Texture t1;
    public Color color;
    public Rectangle rect;
    private int _sw;
    private int _sh;
    public boolean isDead;
    public boolean isCarried;
    public Student st = new Student(0, 0);
    public UUID uuid = UUID.randomUUID();

    public Platinum(float _x, float _y) {
        this.rect = new Rectangle();
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 20.0f;
        this.rect.height = 20.0f;
        this._sw = 20;
        this._sh = 20;
        this.t1 = new Texture(Gdx.files.internal("platinum.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        Array<TextureRegion> frames = new Array<TextureRegion>();
        frames.add(new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 2 * this._sw, 0 * this._sh, this._sw, this._sh));
        frames.add(new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh));
        this.on = new Animation(MathUtils.random(0.05f, 0.1f), frames, Animation.PlayMode.LOOP);
        frames.clear();
        this.color = Color.WHITE;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    private void Update(Array<Student> students, float dt) {
        if (!this.isDead) {
            for (int i = 0; i < students.size; ++i) {
                if (students.get((int)i).uuid != this.uuid) continue;
                this.st = students.get(i);
            }
            if (this.isCarried) {
                if (this.st.isDead) {
                    this.isCarried = false;
                }
                this.rect.x = this.st.rect.x + 16.0f;
                this.rect.y = this.st.rect.y + 50.0f;
            }
        }
    }

    public TextureRegion getFrame(OrthographicCamera camera, float dt, Array<Student> students) {
        TextureRegion region;
        this.Update(students, dt);
        this.currentState = this.getState();
        switch (this.currentState) {
            case ON: {
                region = this.on.getKeyFrame(this._stateTimer, true);
                break;
            }
            case MAIN: {
                region = this.main;
                break;
            }
            default: {
                region = this.on.getKeyFrame(this._stateTimer, true);
            }
        }
        if (this.currentState != this.previousState) {
            this.isAnimationOver = false;
        }
        this._stateTimer = !this.isAnimationOver && this.currentState == this.previousState ? (this._stateTimer += dt) : 0.0f;
        this.previousState = this.currentState;
        return region;
    }

    public State getState() {
        return State.ON;
    }

    public void render(rcr game, OrthographicCamera camera, float dt, Array<Student> students) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(camera, dt, students), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }

    public static enum State {
        MAIN,
        ON;

    }
}

