/*
 * Decompiled with CFR 0.152.
 */
package entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.ld58.game.rcr;
import effects.Ballpit;
import effects.HealthBar;
import entities.Ball;
import entities.Player;
import java.util.HashMap;
import u.UsefulMethods;

public class EnemyGun
extends Sprite {
    public int health = 100;
    public int healthMax = 100;
    public int firingDistance = 100;
    private TextureRegion main;
    private TextureRegion broken;
    private Texture t1;
    public Color color;
    public Rectangle rect;
    public boolean isBroken;
    private int _sw;
    private int _sh;
    public HealthBar healthBar;
    public Array<Ball> balls;
    private Ballpit ballpit;
    private int timer;
    public Vector2 sp = new Vector2(0.0f, 0.0f);
    public Vector2 ep = new Vector2(0.0f, 0.0f);
    Vector2 dir = new Vector2();
    private int ammo;
    private float targetX;
    private float targetY;
    public int fireDelay = 100;

    public EnemyGun(float _x, float _y) {
        this.rect = new Rectangle();
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 25.0f;
        this.rect.height = 25.0f;
        this._sw = 25;
        this._sh = 25;
        this.healthBar = new HealthBar(_x, _y, this._sw, 2.0f);
        this.balls = new Array();
        this.ballpit = new Ballpit();
        this.fireDelay = MathUtils.random(80, 130);
        this.t1 = new Texture(Gdx.files.internal("gun.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.broken = new TextureRegion(this.t1, 1 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.color = Color.WHITE;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    private void update(OrthographicCamera camera, Player player) {
        if (!this.isBroken) {
            for (Ball b : this.balls) {
                if (!b.explosion.isDead) continue;
                if (this.ammo > 0) {
                    --this.ammo;
                }
                this.balls.removeValue(b, true);
                this.ballpit.free(b);
            }
            if (this.timer <= 0) {
                this.timer = this.fireDelay;
                this.fireballstuff(camera, player);
            }
            if (this.timer > 0) {
                --this.timer;
            }
        }
    }

    private void fireballstuff(OrthographicCamera camera, Player player) {
        if (this.balls.size > 0) {
            ++this.ammo;
        }
        this.getClosestEnemy(player);
        this.sp = new Vector2(this.rect.x, this.rect.y);
        this.ep = new Vector2(this.targetX, this.targetY);
        Ball ball = (Ball)this.ballpit.obtain();
        ball.sp.x = this.rect.x;
        ball.sp.y = this.rect.y;
        ball.ep.x = this.ep.x;
        ball.ep.y = this.ep.y;
        this.balls.add(ball);
        this.balls.get((int)this.ammo).dir = UsefulMethods.GetDirection(this.sp, this.ep);
        this.balls.get((int)this.ammo).rect.x = this.sp.x;
        this.balls.get((int)this.ammo).rect.y = this.sp.y;
        this.balls.get((int)this.ammo).fired = true;
        this.balls.get((int)this.ammo).ballLife = this.firingDistance;
        this.balls.get((int)this.ammo).isDead = false;
        this.balls.get((int)this.ammo).canHit = true;
        this.balls.get((int)this.ammo).explosion.isDead = false;
    }

    public Vector2 GetDirection(Vector2 sp, Vector2 ep) {
        return ep.sub(sp).nor();
    }

    private Vector2 getClosestEnemy(Player player) {
        float closestDistance = 1000000.0f;
        Vector2 _sp = new Vector2(this.rect.x, this.rect.y);
        Vector2 _ep = new Vector2(this.ep.x, this.ep.y);
        HashMap<Float, Vector2> _distances = new HashMap<Float, Vector2>();
        if (!player.dead) {
            this.ep = new Vector2(player.rect.x, player.rect.y);
            float dist = UsefulMethods.GetDistance(_sp, this.ep);
            if (dist < closestDistance) {
                closestDistance = dist;
                _ep = this.ep;
            }
            _distances.put(Float.valueOf(closestDistance), _ep);
        }
        for (Float key : _distances.keySet()) {
            if (!(key.floatValue() < closestDistance)) continue;
            closestDistance = key.floatValue();
        }
        Vector2 td = (Vector2)_distances.get(Float.valueOf(closestDistance));
        if (!this.isEmpty(td)) {
            this.setTargetToClosestItem(td.x, td.y);
        } else {
            Vector2 oopsNoOneIsLeft;
            td = oopsNoOneIsLeft = new Vector2(this.rect.x, this.rect.y);
        }
        return td;
    }

    private boolean isEmpty(Vector2 v) {
        return v == null;
    }

    private void setTargetToClosestItem(float _x, float _y) {
        this.targetX = _x;
        this.targetY = _y;
    }

    public TextureRegion getFrame(OrthographicCamera camera, float dt, Player player) {
        this.update(camera, player);
        return this.getTextureRegion();
    }

    public TextureRegion getTextureRegion() {
        if (this.isBroken) {
            return this.broken;
        }
        return this.main;
    }

    public void render(rcr game, OrthographicCamera camera, float dt, Player player) {
        game.batch.setColor(this.color);
        game.batch.draw(this.getFrame(camera, dt, player), this.rect.x, this.rect.y);
    }

    public void dispose() {
    }
}

