/*
 * Decompiled with CFR 0.152.
 */
package effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.ld58.game.rcr;

public class HealthBar
extends Sprite {
    private TextureRegion main;
    private Texture t1;
    public Color color;
    private Rectangle rect = new Rectangle();
    private int _sw;
    private int _sh;
    private int barWidth;
    private int barHeight;

    public HealthBar(float _x, float _y, float _barWidth, float _barHeight) {
        this.barWidth = (int)_barWidth;
        this.barHeight = (int)_barHeight;
        this.rect.x = (int)_x;
        this.rect.y = (int)_y;
        this.rect.width = 100.0f;
        this.rect.height = 5.0f;
        this._sw = 1;
        this._sh = 1;
        this.t1 = new Texture(Gdx.files.internal("onePixel.png"));
        this.main = new TextureRegion(this.t1, 0 * this._sw, 0 * this._sh, this._sw, this._sh);
        this.color = Color.GREEN;
        this.setBounds(0.0f, 0.0f, this._sw, this._sh);
        this.setOriginCenter();
        this.setRegion(this.main);
    }

    private void update(float __x, float __y) {
        this.rect.x = __x - 10.0f;
        this.rect.y = __y + 45.0f;
    }

    public TextureRegion getTextureRegion() {
        return this.main;
    }

    public void render(rcr game, OrthographicCamera camera, float dt, float personRectXToFollow, float personRectYToFollow, int health, int healthMax) {
        this.update(personRectXToFollow, personRectYToFollow);
        float w = (float)health / (float)healthMax * (float)this.barWidth;
        if (health >= healthMax / 2) {
            this.color = Color.GREEN;
        }
        if (health < healthMax / 2) {
            this.color = Color.YELLOW;
        }
        if (health <= healthMax / 3) {
            this.color = Color.ORANGE;
        }
        if (health <= healthMax / 6) {
            this.color = Color.RED;
        }
        game.batch.setColor(this.color);
        game.batch.draw(this.getTextureRegion(), this.rect.x, this.rect.y, w, (float)this.barHeight);
    }

    public void dispose() {
    }
}

